/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.event;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.util.List;

public abstract class DistributedDataEvent
extends CommonDataEvent {
    private static final String TRACE_MASKT = "XPADDEVT";
    private static final String TRACE_MASKF = "XPADDEVF";
    private static final String TRACE_MASKD = "XPADDEVD";
    protected byte[] logData;
    protected String refcode = "";
    protected long firstReportedTime = 0L;
    protected PASystem failingEnclosureSystem = null;
    protected String svcEventText = "";
    protected int eventSeverity = 0;
    protected XMLEncodeableArrayList associatedSystemList = new XMLEncodeableArrayList();
    protected LocalizableText notificationType = null;
    protected int plid = 0;
    protected int subsystemID = 0;
    protected XMLEncodeableArrayList hmcLocaleList = new XMLEncodeableArrayList();
    protected XMLEncodeableArrayList nlsMessages = new XMLEncodeableArrayList();
    protected XMLEncodeableArrayList fruList = new XMLEncodeableArrayList();
    protected String extension = "";
    protected float priority = 50.0f;

    public DistributedDataEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public DistributedDataEvent(Object source, String evtId) {
        super(source, evtId);
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void setData(Object data) {
        Trace.trace(TRACE_MASKD, "--> setData");
        super.setData(data);
        LogEntryId consoleLogId = null;
        PASystem system = null;
        if (data instanceof byte[]) {
            this.logData = (byte[])data;
        } else if (data instanceof Log) {
            try {
                LogBlock dataBlock = ((Log)data).getLogBlock((byte)3);
                if (dataBlock == null) {
                    Trace.trace(TRACE_MASKT, "Couldn't obtain PRIMARY_BLOCK_ID (leaving logData null)");
                } else {
                    this.logData = (byte[])dataBlock.getData();
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Exception processing PRIMARY_BLOCK_ID (leaving logData null)");
                Trace.trace(TRACE_MASKT, e);
            }
            consoleLogId = ((Log)data).getLogEntryId();
            LogBlock systemBlock = ((Log)data).getLogBlock((byte)4);
            if (systemBlock != null) {
                String xmlSystem = null;
                try {
                    xmlSystem = new String((byte[])systemBlock.getData());
                    Trace.trace(TRACE_MASKD, "sec block=" + xmlSystem);
                    system = (PASystem)XMLHelper.rebuildObject(xmlSystem, "*");
                    StringBuffer sb = new StringBuffer();
                    XMLHelper.outToXML(system, sb, system.getClass());
                    Trace.trace(TRACE_MASKD, "rebuilt system=" + sb.toString());
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Couldn't rebuild system");
                    if (xmlSystem != null) {
                        Trace.trace(TRACE_MASKT, "xml=" + xmlSystem);
                    }
                    Trace.trace(TRACE_MASKT, e);
                }
            }
        } else {
            RuntimeException rte = new RuntimeException("Unknown data type used for DistributedDataEvent");
            Trace.trace(TRACE_MASKT, rte);
            Trace.trace(TRACE_MASKD, "<-- setData");
            throw rte;
        }
        if (system != null) {
            RemoteSystem knownSys;
            RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
            if (rsm != null && system instanceof RemoteSystem && (knownSys = rsm.getKnownSystem((RemoteSystem)system)) != null) {
                Trace.trace(TRACE_MASKD, "Associating system with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                system = knownSys;
            }
            this.setSystem(system);
        } else {
            this.setSystem(this.deriveSystem());
        }
        try {
            this.parseData();
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("Exception parsing data", e);
            Trace.trace(TRACE_MASKD, "<-- setData: Exception parsing data");
            throw rte;
        }
        this.setConsoleLogId(consoleLogId);
        Trace.trace(TRACE_MASKD, "event id [" + this.getEventId() + "]");
        Trace.trace(TRACE_MASKD, "<-- setData");
        Trace.trace(TRACE_MASKD, this.toString());
    }

    protected PASystem deriveSystem() {
        return this.getSystem();
    }

    protected abstract void parseData() throws HException;

    public abstract boolean isError();

    public abstract boolean isInfo();

    public abstract boolean isSurveillanceError();

    public void setRefcode(String refcode) {
        this.refcode = refcode;
    }

    public String getRefcode() {
        return this.refcode;
    }

    public void setFirstReportedTime(long firstReportedTime) {
        this.firstReportedTime = firstReportedTime;
    }

    public long getFirstReportedTime() {
        return this.firstReportedTime;
    }

    public PASystem getReportingSystem() {
        return this.getSystem();
    }

    public void setFailingEnclosureSystem(PASystem failingEnclosureSystem) {
        this.failingEnclosureSystem = failingEnclosureSystem;
    }

    public PASystem getFailingEnclosureSystem() {
        return this.failingEnclosureSystem;
    }

    public void setSvcEventText(String svcEventText) {
        this.svcEventText = svcEventText;
    }

    public String getSvcEventText() {
        return this.svcEventText;
    }

    public void setEventSeverity(int eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public int getEventSeverity() {
        return this.eventSeverity;
    }

    public void addAssociatedSystem(PASystem associatedSystem) {
        this.associatedSystemList.add(associatedSystem);
    }

    public List getAssociatedSystemList() {
        return this.associatedSystemList;
    }

    public void setNotificationType(LocalizableText notificationType) {
        this.notificationType = notificationType;
    }

    public LocalizableText getNotificationType() {
        return this.notificationType;
    }

    public void setPlatformLogID(int plid) {
        this.plid = plid;
    }

    public int getPlatformLogID() {
        return this.plid;
    }

    public void setSubsystemID(int subsystemID) {
        this.subsystemID = subsystemID;
    }

    public int getSubsystemID() {
        return this.subsystemID;
    }

    public void addHMCLocales(String[] localeArray) {
        for (int i = 0; i < localeArray.length; ++i) {
            this.hmcLocaleList.add(localeArray[i]);
        }
    }

    public List getHMCLocales() {
        return this.hmcLocaleList;
    }

    public void addNLSMessages(String[] msgArray) {
        for (int i = 0; i < msgArray.length; ++i) {
            this.nlsMessages.add(msgArray[i]);
        }
    }

    public List getNLSMessages() {
        return this.nlsMessages;
    }

    public void addFru(CommonPaFru fru) {
        this.fruList.add(fru);
    }

    public XMLEncodeableArrayList getFruList() {
        return this.fruList;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public float getPriority() {
        return this.priority;
    }

    public boolean isPhypFspSurvEvent() {
        boolean result = false;
        int reasonCode = -1;
        if (this.refcode != null && this.refcode.length() >= 8) {
            String reasonStr = this.refcode.substring(4, 7);
            Trace.trace(TRACE_MASKD, "reasonStr " + reasonStr);
            reasonCode = Integer.valueOf(reasonStr, 16);
            Trace.trace(TRACE_MASKD, "reason code to compare on = " + reasonCode);
        } else {
            result = false;
        }
        if (this.isSurveillanceError() && reasonCode != -1) {
            if (this.getRefcode().equals("B3030011") || this.getRefcode().equals("B3030012")) {
                result = true;
            } else if (reasonCode == 58420 || reasonCode == 58383 || reasonCode == 58378 || reasonCode == 58379) {
                result = true;
            }
        }
        return result;
    }
}

